/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import com.jamieswhiteshirt.reachentityattributes.ReachEntityAttributes;
import com.mojang.authlib.GameProfile;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import io.github.fabricators_of_create.porting_lib.event.common.ItemCraftedCallback;
import io.github.fabricators_of_create.porting_lib.event.common.LivingEntityEvents;
import io.github.fabricators_of_create.porting_lib.event.common.MountEntityCallback;
import io.github.fabricators_of_create.porting_lib.event.common.ProjectileImpactCallback;
import io.github.fabricators_of_create.porting_lib.loot.GlobalLootModifierSerializer;
import io.github.fabricators_of_create.porting_lib.loot.LootModifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import me.pepperbell.simplenetworking.S2CPacket;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.item.v1.ModifyItemAttributeModifiersCallback;
import net.fabricmc.fabric.api.networking.v1.EntityTrackingEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1321;
import net.minecraft.class_1322;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1404;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2190;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2484;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2549;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2631;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3449;
import net.minecraft.class_3489;
import net.minecraft.class_3545;
import net.minecraft.class_3610;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_47;
import net.minecraft.class_5281;
import net.minecraft.class_5341;
import twilightforest.TFConfig;
import twilightforest.TFSounds;
import twilightforest.TwilightForestMod;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.AbstractLightableBlock;
import twilightforest.block.AbstractSkullCandleBlock;
import twilightforest.block.GiantBlock;
import twilightforest.block.KeepsakeCasketBlock;
import twilightforest.block.SkullCandleBlock;
import twilightforest.block.TFBlocks;
import twilightforest.block.TFPortalBlock;
import twilightforest.block.WallSkullCandleBlock;
import twilightforest.block.entity.KeepsakeCasketBlockEntity;
import twilightforest.block.entity.SkullCandleBlockEntity;
import twilightforest.capabilities.CapabilityList;
import twilightforest.capabilities.shield.IShieldCapability;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.enchantment.TFEnchantment;
import twilightforest.entity.CharmEffect;
import twilightforest.entity.IHostileMount;
import twilightforest.entity.TFEntities;
import twilightforest.entity.monster.Kobold;
import twilightforest.entity.passive.Bighorn;
import twilightforest.entity.passive.DwarfRabbit;
import twilightforest.entity.passive.Squirrel;
import twilightforest.entity.passive.TinyBird;
import twilightforest.entity.projectile.ITFProjectile;
import twilightforest.enums.BlockLoggingEnum;
import twilightforest.item.PhantomArmorItem;
import twilightforest.item.TFItems;
import twilightforest.network.AreaProtectionPacket;
import twilightforest.network.EnforceProgressionStatusPacket;
import twilightforest.network.TFPacketHandler;
import twilightforest.network.UpdateShieldPacket;
import twilightforest.potions.TFMobEffects;
import twilightforest.util.TFItemStackUtils;
import twilightforest.util.TFStats;
import twilightforest.util.WorldUtil;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;
import twilightforest.world.registration.TFFeature;
import twilightforest.world.registration.TFGenerationSettings;

public class TFEventListener {
    public static final String CHARM_INV_TAG = "TFCharmInventory";
    private static final ImmutableSet<String> SHIELD_DAMAGE_BLACKLIST = ImmutableSet.of((Object)"inWall", (Object)"cramming", (Object)"drown", (Object)"starve", (Object)"fall", (Object)"flyIntoWall", (Object[])new String[]{"outOfWorld", "fallingBlock"});
    private static boolean isBreakingWithGiantPick = false;
    private static boolean shouldMakeGiantCobble = false;
    private static int amountOfCobbleToReplace = 0;
    private static boolean casketExpiration = false;
    private static final String PERSISTED_NBT_TAG = "PlayerPersisted";
    private static class_1799 charmUsed;
    public static volatile boolean allowDismount;
    private static final String NBT_TAG_TWILIGHT = "twilightforest_banished";
    private static final boolean globalParry;

    public static void init() {
        ServerEntityEvents.ENTITY_LOAD.register(TFEventListener::addPrey);
        ItemCraftedCallback.EVENT.register(TFEventListener::onCrafting);
        LivingEntityEvents.ACTUALLY_HURT.register(TFEventListener::entityHurts);
        LivingEntityEvents.TICK.register(TFEventListener::livingUpdate);
        LivingEntityEvents.ATTACK.register(TFEventListener::livingAttack);
        LivingEntityEvents.EQUIPMENT_CHANGE.register(TFEventListener::armorChanged);
        UseBlockCallback.EVENT.register(TFEventListener::createSkullCandle);
        UseBlockCallback.EVENT.register(TFEventListener::onPlayerRightClick);
        PlayerBlockBreakEvents.BEFORE.register(TFEventListener::onCasketBreak);
        PlayerBlockBreakEvents.BEFORE.register(TFEventListener::breakBlock);
        ServerPlayerEvents.AFTER_RESPAWN.register(TFEventListener::onPlayerRespawn);
        ServerPlayerEvents.ALLOW_DEATH.register(TFEventListener::applyDeathItems);
        ProjectileImpactCallback.EVENT.register(TFEventListener::throwableParry);
        ModifyItemAttributeModifiersCallback.EVENT.register(TFEventListener::addReach);
        EntityTrackingEvents.START_TRACKING.register(TFEventListener::onStartTracking);
        MountEntityCallback.EVENT.register(TFEventListener::preventMountDismount);
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register(TFEventListener::playerPortals);
    }

    public static void addReach(class_1799 stack, class_1304 slotType, Multimap<class_1320, class_1322> modifiers) {
        class_1792 item = stack.method_7909();
        if ((item == TFItems.GIANT_PICKAXE.get() || item == TFItems.GIANT_SWORD.get()) && slotType == class_1304.field_6173) {
            modifiers.put((Object)ReachEntityAttributes.REACH, (Object)new class_1322(TFItems.GIANT_REACH_MODIFIER, "Tool modifier", 2.5, class_1322.class_1323.field_6328));
        }
    }

    public static void addPrey(class_1297 entity, class_3218 world) {
        class_1299 type = entity.method_5864();
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            if (type == class_1299.field_16281) {
                mob.field_6185.method_6277(1, (class_1352)new class_1404((class_1321)entity, DwarfRabbit.class, false, null));
                mob.field_6185.method_6277(1, (class_1352)new class_1404((class_1321)entity, Squirrel.class, false, null));
                mob.field_6185.method_6277(1, (class_1352)new class_1404((class_1321)entity, TinyBird.class, false, null));
            } else if (type == class_1299.field_6081) {
                mob.field_6185.method_6277(1, (class_1352)new class_1400(mob, DwarfRabbit.class, false));
                mob.field_6185.method_6277(1, (class_1352)new class_1400(mob, Squirrel.class, false));
                mob.field_6185.method_6277(1, (class_1352)new class_1400(mob, TinyBird.class, false));
            } else if (type == class_1299.field_17943) {
                mob.field_6185.method_6277(6, (class_1352)new class_1400(mob, DwarfRabbit.class, false));
                mob.field_6185.method_6277(6, (class_1352)new class_1400(mob, Squirrel.class, false));
            } else if (type == class_1299.field_6055) {
                mob.field_6185.method_6277(7, (class_1352)new class_1404((class_1321)entity, DwarfRabbit.class, false, null));
                mob.field_6185.method_6277(7, (class_1352)new class_1404((class_1321)entity, Squirrel.class, false, null));
                mob.field_6185.method_6277(7, (class_1352)new class_1404((class_1321)entity, Bighorn.class, false, null));
            }
        }
    }

    public static void onCrafting(class_1657 player, class_1799 itemStack, class_1263 inventory) {
        if (itemStack.method_31574(class_1802.field_8118) && itemStack.method_7947() == 64 && inventory.method_18861(((class_2248)TFBlocks.GIANT_LOG.get()).method_8389()) > 0) {
            player.method_31548().method_7398(new class_1799((class_1935)class_1802.field_8118, 64));
            player.method_31548().method_7398(new class_1799((class_1935)class_1802.field_8118, 64));
            player.method_31548().method_7398(new class_1799((class_1935)class_1802.field_8118, 64));
        }
    }

    public static float entityHurts(class_1282 damageSource, class_1309 living, float amount) {
        int chillLevel;
        class_1657 player;
        int fireLevel;
        String damageType = damageSource.method_5525();
        class_1297 trueSource = damageSource.method_5529();
        if (living instanceof class_1657 && (damageType.equals("mob") || damageType.equals("player")) && trueSource != null && (fireLevel = TFEnchantment.getFieryAuraLevel((player = (class_1657)living).method_31548(), damageSource)) > 0 && player.method_6051().nextInt(25) < fireLevel) {
            trueSource.method_5639(fireLevel / 2);
        }
        if (living instanceof class_1657 && (damageType.equals("mob") || damageType.equals("player")) && trueSource instanceof class_1309 && (chillLevel = TFEnchantment.getChillAuraLevel((player = (class_1657)living).method_31548(), damageSource)) > 0) {
            ((class_1309)trueSource).method_6092(new class_1293((class_1291)TFMobEffects.FROSTY.get(), chillLevel * 5 + 5, chillLevel));
        }
        if (damageType.equals("arrow") && trueSource instanceof class_1657 && ((player = (class_1657)trueSource).method_6047().method_7909() == TFItems.TRIPLE_BOW.get() || player.method_6079().method_7909() == TFItems.TRIPLE_BOW.get())) {
            living.field_6008 = 0;
        }
        if (living instanceof class_1657 && TFEventListener.isRidingUnfriendly(living) && damageSource == class_1282.field_5855) {
            return 0.0f;
        }
        return amount;
    }

    public static class_1269 createSkullCandle(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        class_1799 stack = player.method_5998(hand);
        class_2338 pos = hitResult.method_17777();
        class_2680 state = world.method_8320(pos);
        if (!((Boolean)TFConfig.COMMON_CONFIG.disableSkullCandles.get()).booleanValue() && stack.method_31573(class_3489.field_26989) && class_2378.field_11142.method_10221((Object)stack.method_7909()).method_12836().equals("minecraft") && !player.method_5715() && state.method_26204() instanceof class_2190 && class_2378.field_11146.method_10221((Object)state.method_26204()).method_12836().equals("minecraft")) {
            class_2484.class_2486 type = (class_2484.class_2486)((class_2190)state.method_26204()).method_9327();
            boolean wall = state.method_26204() instanceof class_2549;
            switch (type) {
                case field_11512: {
                    if (wall) {
                        TFEventListener.makeWallSkull(stack, pos, world, (class_2248)TFBlocks.SKELETON_WALL_SKULL_CANDLE.get());
                        break;
                    }
                    TFEventListener.makeFloorSkull(stack, pos, world, (class_2248)TFBlocks.SKELETON_SKULL_CANDLE.get());
                    break;
                }
                case field_11513: {
                    if (wall) {
                        TFEventListener.makeWallSkull(stack, pos, world, (class_2248)TFBlocks.WITHER_SKELE_WALL_SKULL_CANDLE.get());
                        break;
                    }
                    TFEventListener.makeFloorSkull(stack, pos, world, (class_2248)TFBlocks.WITHER_SKELE_SKULL_CANDLE.get());
                    break;
                }
                case field_11510: {
                    if (wall) {
                        TFEventListener.makeWallSkull(stack, pos, world, (class_2248)TFBlocks.PLAYER_WALL_SKULL_CANDLE.get());
                        break;
                    }
                    TFEventListener.makeFloorSkull(stack, pos, world, (class_2248)TFBlocks.PLAYER_SKULL_CANDLE.get());
                    break;
                }
                case field_11508: {
                    if (wall) {
                        TFEventListener.makeWallSkull(stack, pos, world, (class_2248)TFBlocks.ZOMBIE_WALL_SKULL_CANDLE.get());
                        break;
                    }
                    TFEventListener.makeFloorSkull(stack, pos, world, (class_2248)TFBlocks.ZOMBIE_SKULL_CANDLE.get());
                    break;
                }
                case field_11507: {
                    if (wall) {
                        TFEventListener.makeWallSkull(stack, pos, world, (class_2248)TFBlocks.CREEPER_WALL_SKULL_CANDLE.get());
                        break;
                    }
                    TFEventListener.makeFloorSkull(stack, pos, world, (class_2248)TFBlocks.CREEPER_SKULL_CANDLE.get());
                    break;
                }
                default: {
                    return class_1269.field_5811;
                }
            }
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            player.method_6104(hand);
            if (player instanceof class_3222) {
                player.method_7281((class_2960)TFStats.SKULL_CANDLES_MADE.get());
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private static void makeFloorSkull(class_1799 stack, class_2338 pos, class_1937 world, class_2248 newBlock) {
        GameProfile profile = null;
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof class_2631) {
            class_2631 skull = (class_2631)class_25862;
            profile = skull.method_11334();
        }
        world.method_8396(null, pos, class_3417.field_26958, class_3419.field_15245, 1.0f, 1.0f);
        world.method_8501(pos, (class_2680)((class_2680)newBlock.method_9564().method_11657((class_2769)AbstractSkullCandleBlock.LIGHTING, (Comparable)((Object)AbstractLightableBlock.Lighting.NONE))).method_11657((class_2769)SkullCandleBlock.ROTATION, (Comparable)((Integer)world.method_8320(pos).method_11654((class_2769)class_2484.field_11505))));
        world.method_8438((class_2586)new SkullCandleBlockEntity(pos, (class_2680)((class_2680)newBlock.method_9564().method_11657((class_2769)AbstractSkullCandleBlock.LIGHTING, (Comparable)((Object)AbstractLightableBlock.Lighting.NONE))).method_11657((class_2769)SkullCandleBlock.ROTATION, (Comparable)((Integer)world.method_8320(pos).method_11654((class_2769)class_2484.field_11505))), AbstractSkullCandleBlock.candleToCandleColor(stack.method_7909()).getValue(), 1));
        class_25862 = world.method_8321(pos);
        if (class_25862 instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)class_25862;
            sc.method_11333(profile);
        }
    }

    private static void makeWallSkull(class_1799 stack, class_2338 pos, class_1937 world, class_2248 newBlock) {
        GameProfile profile = null;
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof class_2631) {
            class_2631 skull = (class_2631)class_25862;
            profile = skull.method_11334();
        }
        world.method_8396(null, pos, class_3417.field_26958, class_3419.field_15245, 1.0f, 1.0f);
        world.method_8501(pos, (class_2680)((class_2680)newBlock.method_9564().method_11657((class_2769)AbstractSkullCandleBlock.LIGHTING, (Comparable)((Object)AbstractLightableBlock.Lighting.NONE))).method_11657((class_2769)WallSkullCandleBlock.FACING, (Comparable)((class_2350)world.method_8320(pos).method_11654((class_2769)class_2549.field_11724))));
        world.method_8438((class_2586)new SkullCandleBlockEntity(pos, (class_2680)((class_2680)newBlock.method_9564().method_11657((class_2769)AbstractSkullCandleBlock.LIGHTING, (Comparable)((Object)AbstractLightableBlock.Lighting.NONE))).method_11657((class_2769)WallSkullCandleBlock.FACING, (Comparable)((class_2350)world.method_8320(pos).method_11654((class_2769)class_2549.field_11724))), AbstractSkullCandleBlock.candleToCandleColor(stack.method_7909()).getValue(), 1));
        class_25862 = world.method_8321(pos);
        if (class_25862 instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)class_25862;
            sc.method_11333(profile);
        }
    }

    private static boolean hasCharmCurio(class_1792 item, class_1657 player) {
        List slots;
        if (FabricLoader.getInstance().isModLoaded("trinkets") && !(slots = ((TrinketComponent)player.getComponent(TrinketsApi.TRINKET_COMPONENT)).getEquipped(stack -> stack.method_31574(item))).isEmpty() && !((class_1799)((class_3545)slots.get(0)).method_15441()).method_7960()) {
            ((class_1799)((class_3545)slots.get(0)).method_15441()).method_7934(1);
            return true;
        }
        return false;
    }

    public static boolean applyDeathItems(class_3222 player, class_1282 damageSource, float damageAmount) {
        if (player.method_7337()) {
            return true;
        }
        if (TFEventListener.charmOfLife((class_1657)player)) {
            return false;
        }
        if (!player.field_6002.method_8450().method_8355(class_1928.field_19389)) {
            TFEventListener.charmOfKeeping((class_1657)player);
            TFEventListener.keepsakeCasket((class_1657)player);
        }
        return true;
    }

    private static void keepsakeCasket(class_1657 player) {
        boolean casketConsumed = TFItemStackUtils.consumeInventoryItem(player, ((KeepsakeCasketBlock)TFBlocks.KEEPSAKE_CASKET.get()).method_8389());
        if (casketConsumed) {
            class_1937 world = player.method_5770();
            class_2338.class_2339 pos = player.method_24515().method_25503();
            if (pos.method_10264() < 2) {
                pos.method_33098(2);
            } else {
                int logicalHeight = player.method_5770().method_8597().method_32925();
                if (pos.method_10264() > logicalHeight) {
                    pos.method_33098(logicalHeight - 1);
                }
            }
            class_2338 immutablePos = pos.method_10062();
            class_3610 fluidState = world.method_8316(immutablePos);
            if (world.method_8501(immutablePos, (class_2680)((class_2680)((KeepsakeCasketBlock)TFBlocks.KEEPSAKE_CASKET.get()).method_9564().method_11657(BlockLoggingEnum.MULTILOGGED, (Comparable)((Object)BlockLoggingEnum.getFromFluid(fluidState.method_15772())))).method_11657((class_2769)KeepsakeCasketBlock.BREAKAGE, (Comparable)Integer.valueOf(TFItemStackUtils.damage)))) {
                class_2586 te = world.method_8321(immutablePos);
                if (te instanceof KeepsakeCasketBlockEntity) {
                    KeepsakeCasketBlockEntity casket = (KeepsakeCasketBlockEntity)te;
                    casket.playeruuid = (Boolean)TFConfig.COMMON_CONFIG.casketUUIDLocking.get() != false ? player.method_7334().getId() : null;
                    String modifiedName = player.method_5477().getString().length() > 12 ? player.method_5477().getString().substring(0, 12) : player.method_5477().getString();
                    casket.name = player.method_5477().getString();
                    casket.casketname = modifiedName;
                    casket.method_17488((class_2561)new class_2585(modifiedName + "'s " + (world.field_9229.nextInt(10000) == 0 ? "Costco Casket" : casket.method_5476().getString())));
                    int damage = (Integer)world.method_8320(immutablePos).method_11654((class_2769)KeepsakeCasketBlock.BREAKAGE);
                    if (world.field_9229.nextFloat() <= 0.15f) {
                        if (damage >= 2) {
                            player.method_31548().method_7388();
                            world.method_8501(immutablePos, class_2246.field_10124.method_9564());
                            casketExpiration = true;
                            TwilightForestMod.LOGGER.debug("{}'s Casket damage value was too high, alerting the player and dropping extra items", (Object)player.method_5477().getString());
                        } else {
                            world.method_8501(immutablePos, (class_2680)((class_2680)((KeepsakeCasketBlock)TFBlocks.KEEPSAKE_CASKET.get()).method_9564().method_11657(BlockLoggingEnum.MULTILOGGED, (Comparable)((Object)BlockLoggingEnum.getFromFluid(fluidState.method_15772())))).method_11657((class_2769)KeepsakeCasketBlock.BREAKAGE, (Comparable)Integer.valueOf(++damage)));
                            TwilightForestMod.LOGGER.debug("{}'s Casket was randomly damaged, applying new damage", (Object)player.method_5477().getString());
                        }
                    }
                    int casketCapacity = casket.method_5439();
                    ArrayList<class_1799> list = new ArrayList<class_1799>(casketCapacity);
                    class_2371 filler = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
                    list.addAll((Collection<class_1799>)TFItemStackUtils.sortArmorForCasket(player));
                    player.method_31548().field_7548.clear();
                    list.addAll((Collection<class_1799>)filler);
                    list.addAll((Collection<class_1799>)player.method_31548().field_7544);
                    player.method_31548().field_7544.clear();
                    list.addAll((Collection<class_1799>)TFItemStackUtils.sortInvForCasket(player));
                    player.method_31548().field_7547.clear();
                    casket.method_11281((class_2371<class_1799>)class_2371.method_10212((Object)class_1799.field_8037, (Object[])list.toArray(new class_1799[casketCapacity])));
                }
            } else {
                TwilightForestMod.LOGGER.error("Could not place Keepsake Casket at " + pos);
            }
        }
    }

    public static boolean onCasketBreak(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 te) {
        class_2248 block = state.method_26204();
        if (block == TFBlocks.KEEPSAKE_CASKET.get()) {
            UUID checker;
            if (te instanceof KeepsakeCasketBlockEntity) {
                KeepsakeCasketBlockEntity casket = (KeepsakeCasketBlockEntity)te;
                checker = casket.playeruuid;
            } else {
                checker = null;
            }
            if (!(checker == null || ((KeepsakeCasketBlockEntity)te).method_5442() || player.method_5687(3) && player.method_7334().getId().equals(checker))) {
                return false;
            }
        }
        return true;
    }

    private static boolean charmOfLife(class_1657 player) {
        boolean charm1;
        boolean charm2 = TFItemStackUtils.consumeInventoryItem(player, (class_1792)TFItems.CHARM_OF_LIFE_2.get()) || TFEventListener.hasCharmCurio((class_1792)TFItems.CHARM_OF_LIFE_2.get(), player);
        boolean bl = charm1 = !charm2 && (TFItemStackUtils.consumeInventoryItem(player, (class_1792)TFItems.CHARM_OF_LIFE_1.get()) || TFEventListener.hasCharmCurio((class_1792)TFItems.CHARM_OF_LIFE_1.get(), player));
        if (charm2 || charm1) {
            if (charm1) {
                player.method_6033(8.0f);
                player.method_6092(new class_1293(class_1294.field_5924, 100, 0));
            }
            if (charm2) {
                player.method_6033(player.method_6063());
                player.method_6092(new class_1293(class_1294.field_5924, 600, 3));
                player.method_6092(new class_1293(class_1294.field_5907, 600, 0));
                player.method_6092(new class_1293(class_1294.field_5918, 600, 0));
            }
            CharmEffect effect = new CharmEffect((class_1299<? extends CharmEffect>)((class_1299)TFEntities.CHARM_EFFECT.get()), player.field_6002, (class_1309)player, charm1 ? (class_1792)TFItems.CHARM_OF_LIFE_1.get() : (class_1792)TFItems.CHARM_OF_LIFE_2.get());
            player.field_6002.method_8649((class_1297)effect);
            CharmEffect effect2 = new CharmEffect((class_1299<? extends CharmEffect>)((class_1299)TFEntities.CHARM_EFFECT.get()), player.field_6002, (class_1309)player, charm1 ? (class_1792)TFItems.CHARM_OF_LIFE_1.get() : (class_1792)TFItems.CHARM_OF_LIFE_2.get());
            effect2.offset = (float)Math.PI;
            player.field_6002.method_8649((class_1297)effect2);
            player.field_6002.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), TFSounds.CHARM_LIFE, player.method_5634(), 1.0f, 1.0f);
            if (player instanceof class_3222) {
                player.method_7281((class_2960)TFStats.LIFE_CHARMS_ACTIVATED.get());
            }
            return true;
        }
        return false;
    }

    public static class_2487 getPlayerData(class_1657 player) {
        if (!player.getExtraCustomData().method_10545(PERSISTED_NBT_TAG)) {
            player.getExtraCustomData().method_10566(PERSISTED_NBT_TAG, (class_2520)new class_2487());
        }
        return player.getExtraCustomData().method_10562(PERSISTED_NBT_TAG);
    }

    private static void charmOfKeeping(class_1657 player) {
        int i;
        boolean tier3 = TFItemStackUtils.consumeInventoryItem(player, (class_1792)TFItems.CHARM_OF_KEEPING_3.get()) || TFEventListener.hasCharmCurio((class_1792)TFItems.CHARM_OF_KEEPING_3.get(), player);
        boolean tier2 = tier3 || TFItemStackUtils.consumeInventoryItem(player, (class_1792)TFItems.CHARM_OF_KEEPING_2.get()) || TFEventListener.hasCharmCurio((class_1792)TFItems.CHARM_OF_KEEPING_2.get(), player);
        boolean tier1 = tier2 || TFItemStackUtils.consumeInventoryItem(player, (class_1792)TFItems.CHARM_OF_KEEPING_1.get()) || TFEventListener.hasCharmCurio((class_1792)TFItems.CHARM_OF_KEEPING_1.get(), player);
        class_1661 keepInventory = new class_1661(null);
        class_2499 tagList = new class_2499();
        if (tier1) {
            TFEventListener.keepWholeList((class_2371<class_1799>)keepInventory.field_7548, (class_2371<class_1799>)player.method_31548().field_7548);
            TFEventListener.keepWholeList((class_2371<class_1799>)keepInventory.field_7544, (class_2371<class_1799>)player.method_31548().field_7544);
        }
        if (tier3) {
            TFEventListener.keepWholeList((class_2371<class_1799>)keepInventory.field_7547, (class_2371<class_1799>)player.method_31548().field_7547);
            charmUsed = new class_1799((class_1935)TFItems.CHARM_OF_KEEPING_3.get());
        } else if (tier2) {
            for (i = 0; i < 9; ++i) {
                keepInventory.field_7547.set(i, (Object)((class_1799)player.method_31548().field_7547.get(i)).method_7972());
                player.method_31548().field_7547.set(i, (Object)class_1799.field_8037);
            }
            charmUsed = new class_1799((class_1935)TFItems.CHARM_OF_KEEPING_2.get());
        } else if (tier1) {
            i = player.method_31548().field_7545;
            if (class_1661.method_7380((int)i)) {
                keepInventory.field_7547.set(i, (Object)((class_1799)player.method_31548().field_7547.get(i)).method_7972());
                player.method_31548().field_7547.set(i, (Object)class_1799.field_8037);
            }
            charmUsed = new class_1799((class_1935)TFItems.CHARM_OF_KEEPING_1.get());
        }
        for (i = 0; i < player.method_31548().field_7547.size(); ++i) {
            class_1799 stack = (class_1799)player.method_31548().field_7547.get(i);
            if (stack.method_7909() == TFItems.TOWER_KEY.get()) {
                keepInventory.field_7547.set(i, (Object)stack.method_7972());
                player.method_31548().field_7547.set(i, (Object)class_1799.field_8037);
            }
            if (!(stack.method_7909() instanceof PhantomArmorItem)) continue;
            keepInventory.field_7547.set(i, (Object)stack.method_7972());
            player.method_31548().field_7547.set(i, (Object)class_1799.field_8037);
        }
        for (i = 0; i < player.method_31548().field_7548.size(); ++i) {
            class_1799 armor = (class_1799)player.method_31548().field_7548.get(i);
            if (!(armor.method_7909() instanceof PhantomArmorItem)) continue;
            keepInventory.field_7548.set(i, (Object)armor.method_7972());
            player.method_31548().field_7548.set(i, (Object)class_1799.field_8037);
        }
        if (!keepInventory.method_5442()) {
            keepInventory.method_7384(tagList);
            TFEventListener.getPlayerData(player).method_10566(CHARM_INV_TAG, (class_2520)tagList);
        }
    }

    private static void keepWholeList(class_2371<class_1799> transferTo, class_2371<class_1799> transferFrom) {
        for (int i = 0; i < transferFrom.size(); ++i) {
            transferTo.set(i, (Object)((class_1799)transferFrom.get(i)).method_7972());
        }
        transferFrom.clear();
    }

    public static void onPlayerRespawn(class_3222 oldPlayer, class_3222 newPlayer, boolean alive) {
        if (alive) {
            TFEventListener.updateCapabilities(newPlayer, (class_1297)newPlayer);
        } else {
            if (casketExpiration) {
                newPlayer.method_9203((class_2561)new class_2588("block.twilightforest.casket.broken").method_27692(class_124.field_1079), newPlayer.method_5667());
            }
            TFEventListener.returnStoredItems((class_1657)oldPlayer, (class_1657)newPlayer);
        }
        if (((Boolean)TFConfig.COMMON_CONFIG.DIMENSION.newPlayersSpawnInTF.get()).booleanValue() && newPlayer.method_26280() == null) {
            class_2487 tagCompound = newPlayer.getExtraCustomData();
            class_2487 playerData = tagCompound.method_10562(PERSISTED_NBT_TAG);
            playerData.method_10556(NBT_TAG_TWILIGHT, false);
            tagCompound.method_10566(PERSISTED_NBT_TAG, (class_2520)playerData);
            TFEventListener.banishNewbieToTwilightZone((class_1657)newPlayer);
        }
    }

    private static void returnStoredItems(class_1657 oldPlayer, class_1657 player) {
        TwilightForestMod.LOGGER.debug("Player {} ({}) respawned and received items held in storage", (Object)player.method_5477().getString(), (Object)player.method_5667());
        class_2487 playerData = TFEventListener.getPlayerData(oldPlayer);
        if (!player.field_6002.field_9236 && playerData.method_10545(CHARM_INV_TAG)) {
            class_2499 tagList = playerData.method_10554(CHARM_INV_TAG, 10);
            TFItemStackUtils.loadNoClear(tagList, player.method_31548());
            TFEventListener.getPlayerData(player).method_10554(CHARM_INV_TAG, 10).clear();
            TFEventListener.getPlayerData(player).method_10551(CHARM_INV_TAG);
        }
        if (charmUsed != null) {
            CharmEffect effect = new CharmEffect((class_1299<? extends CharmEffect>)((class_1299)TFEntities.CHARM_EFFECT.get()), player.field_6002, (class_1309)player, charmUsed.method_7909());
            player.field_6002.method_8649((class_1297)effect);
            CharmEffect effect2 = new CharmEffect((class_1299<? extends CharmEffect>)((class_1299)TFEntities.CHARM_EFFECT.get()), player.field_6002, (class_1309)player, charmUsed.method_7909());
            effect2.offset = (float)Math.PI;
            player.field_6002.method_8649((class_1297)effect2);
            player.field_6002.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), TFSounds.CHARM_KEEP, player.method_5634(), 1.5f, 1.0f);
            if (player instanceof class_3222) {
                player.method_7281((class_2960)TFStats.KEEPING_CHARMS_ACTIVATED.get());
            }
            charmUsed = null;
        }
    }

    public static void livingUpdate(class_1309 entity) {
        CapabilityList.SHIELDS.maybeGet((Object)entity).ifPresent(IShieldCapability::update);
        if (entity instanceof IHostileMount) {
            entity.method_5685().forEach(e -> e.method_5660(false));
        }
    }

    public static class_1269 preventMountDismount(class_1297 mounted, class_1297 mounting, boolean isMounting) {
        class_1309 living;
        if (!mounted.field_6002.method_8608() && !isMounting && mounted.method_5805() && mounting instanceof class_1309 && (living = (class_1309)mounting).method_5805() && TFEventListener.isRidingUnfriendly(living) && !allowDismount) {
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public static boolean isRidingUnfriendly(class_1309 entity) {
        return entity.method_5765() && entity.method_5854() instanceof IHostileMount;
    }

    public static boolean breakBlock(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        if (world.field_9236) {
            return true;
        }
        boolean cancelled = false;
        if (TFEventListener.isBlockProtectedFromBreaking(world, pos) && TFEventListener.isAreaProtected(world, player, pos)) {
            cancelled = true;
        } else if (!isBreakingWithGiantPick && TFEventListener.canHarvestWithGiantPick(player, state)) {
            boolean allCobble;
            isBreakingWithGiantPick = true;
            class_1792 cobbleItem = class_2246.field_10445.method_8389();
            boolean bl = allCobble = state.method_26204().method_8389() == cobbleItem;
            if (allCobble) {
                for (class_2338 dPos : GiantBlock.getVolume(pos)) {
                    class_2680 stateThere;
                    if (dPos.equals((Object)pos) || (stateThere = world.method_8320(dPos)).method_26204().method_8389() == cobbleItem) continue;
                    allCobble = false;
                    break;
                }
            }
            if (allCobble && !player.method_31549().field_7477) {
                shouldMakeGiantCobble = true;
                amountOfCobbleToReplace = 64;
            } else {
                shouldMakeGiantCobble = false;
                amountOfCobbleToReplace = 0;
            }
            if (player instanceof class_3222) {
                class_3222 playerMP = (class_3222)player;
                for (class_2338 dPos : GiantBlock.getVolume(pos)) {
                    if (dPos.equals((Object)pos) || state.method_26204() != world.method_8320(dPos).method_26204()) continue;
                    playerMP.field_13974.method_14266(dPos);
                }
            }
            isBreakingWithGiantPick = false;
        }
        return !cancelled;
    }

    private static boolean canHarvestWithGiantPick(class_1657 player, class_2680 state) {
        class_1799 heldStack = player.method_6047();
        class_1792 heldItem = heldStack.method_7909();
        return heldItem == TFItems.GIANT_PICKAXE.get() && heldItem.method_7856(state);
    }

    public static class_1269 onPlayerRightClick(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        if (!world.field_9236 && TFEventListener.isBlockProtectedFromInteraction(world, hitResult.method_17777()) && TFEventListener.isAreaProtected(world, player, hitResult.method_17777())) {
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    private static boolean isBlockProtectedFromInteraction(class_1937 world, class_2338 pos) {
        return world.method_8320(pos).method_26164(BlockTagGenerator.STRUCTURE_BANNED_INTERACTIONS);
    }

    private static boolean isBlockProtectedFromBreaking(class_1937 world, class_2338 pos) {
        return !world.method_8320(pos).method_26164(BlockTagGenerator.PROGRESSION_ALLOW_BREAKING);
    }

    private static boolean isAreaProtected(class_1937 world, class_1657 player, class_2338 pos) {
        TFFeature nearbyFeature;
        class_3449 structure;
        Optional<class_3449> struct;
        if (player.method_31549().field_7477 || !TFGenerationSettings.isProgressionEnforced(world)) {
            return false;
        }
        ChunkGeneratorTwilight chunkGenerator = WorldUtil.getChunkGenerator((class_1936)world);
        if (chunkGenerator != null && (struct = TFGenerationSettings.locateTFStructureInRange((class_5281)((class_3218)world), pos, 0)).isPresent() && (structure = struct.get()).method_14969().method_14662((class_2382)pos) && !(nearbyFeature = TFFeature.getFeatureAt(pos.method_10263(), pos.method_10260(), (class_5281)((class_3218)world))).doesPlayerHaveRequiredAdvancements(player)) {
            if (nearbyFeature == TFFeature.KNIGHT_STRONGHOLD && pos.method_10264() >= 0) {
                return false;
            }
            ArrayList<class_3341> boxes = new ArrayList<class_3341>();
            structure.method_14963().forEach(piece -> {
                if (piece.method_14935().method_14662((class_2382)pos)) {
                    boxes.add(piece.method_14935());
                }
            });
            TFEventListener.sendAreaProtectionPacket(world, pos, boxes);
            nearbyFeature.trySpawnHintMonster(world, player, pos);
            return true;
        }
        return false;
    }

    private static void sendAreaProtectionPacket(class_1937 world, class_2338 pos, List<class_3341> sbb) {
        TFPacketHandler.CHANNEL.sendToClientsAround((S2CPacket)new AreaProtectionPacket(sbb, pos), (class_3218)world, (class_2382)pos, 64.0);
    }

    public static boolean livingAttack(class_1309 living, class_1282 source, float amount) {
        if (!living.field_6002.field_9236 && living instanceof class_1569 && source.method_5529() instanceof class_1657 && !(living instanceof Kobold) && TFEventListener.isAreaProtected(living.field_6002, (class_1657)source.method_5529(), new class_2338((class_2382)living.method_24515()))) {
            return true;
        }
        AtomicBoolean cancelled = new AtomicBoolean(false);
        if (!living.field_6002.field_9236 && !SHIELD_DAMAGE_BLACKLIST.contains((Object)source.field_5841)) {
            CapabilityList.SHIELDS.maybeGet((Object)living).ifPresent(cap -> {
                if (cap.shieldsLeft() > 0) {
                    cap.breakShield();
                    cancelled.set(true);
                }
            });
        }
        return cancelled.get();
    }

    public static void playerLogsIn(class_3222 player) {
        TFEventListener.sendEnforcedProgressionStatus(player, TFGenerationSettings.isProgressionEnforced(player.field_6002));
        TFEventListener.updateCapabilities(player, (class_1297)player);
        TFEventListener.banishNewbieToTwilightZone((class_1657)player);
    }

    public static void playerPortals(class_3222 player, class_3218 origin, class_3218 destination) {
        if (TFGenerationSettings.usesTwilightChunkGenerator(player.method_14220())) {
            TFEventListener.sendEnforcedProgressionStatus(player, TFGenerationSettings.isProgressionEnforced((class_1937)player.method_14220()));
        }
        TFEventListener.updateCapabilities(player, (class_1297)player);
    }

    public static void onStartTracking(class_1297 trackedEntity, class_3222 player) {
        TFEventListener.updateCapabilities(player, trackedEntity);
    }

    private static void updateCapabilities(class_3222 clientTarget, class_1297 shielded) {
        CapabilityList.SHIELDS.maybeGet((Object)shielded).ifPresent(cap -> {
            if (cap.shieldsLeft() > 0) {
                TFPacketHandler.CHANNEL.sendToClient((S2CPacket)new UpdateShieldPacket(shielded, (IShieldCapability)cap), clientTarget);
            }
        });
    }

    private static void sendEnforcedProgressionStatus(class_3222 player, boolean isEnforced) {
        TFPacketHandler.CHANNEL.sendToClient((S2CPacket)new EnforceProgressionStatusPacket(isEnforced), player);
    }

    private static void banishNewbieToTwilightZone(class_1657 player) {
        class_2487 tagCompound = player.getExtraCustomData();
        class_2487 playerData = tagCompound.method_10562(PERSISTED_NBT_TAG);
        boolean shouldBanishPlayer = (Boolean)TFConfig.COMMON_CONFIG.DIMENSION.newPlayersSpawnInTF.get() != false && !playerData.method_10577(NBT_TAG_TWILIGHT);
        playerData.method_10556(NBT_TAG_TWILIGHT, true);
        tagCompound.method_10566(PERSISTED_NBT_TAG, (class_2520)playerData);
        if (shouldBanishPlayer) {
            TFPortalBlock.attemptSendEntity((class_1297)player, true, (Boolean)TFConfig.COMMON_CONFIG.DIMENSION.portalForNewPlayerSpawn.get());
        }
    }

    public static void armorChanged(class_1309 living, class_1304 slot, @Nonnull class_1799 from, @Nonnull class_1799 to) {
        if (!living.field_6002.field_9236 && living instanceof class_3222) {
            TFAdvancements.ARMOR_CHANGED.trigger((class_3222)living, from, to);
        }
    }

    public static boolean throwableParry(final class_1676 projectile, class_239 hitResult) {
        if (!projectile.method_5770().field_9236 && globalParry && (((Boolean)TFConfig.COMMON_CONFIG.SHIELD_INTERACTIONS.parryNonTwilightAttacks.get()).booleanValue() || projectile instanceof ITFProjectile) && hitResult instanceof class_3966) {
            class_1309 entityBlocking;
            class_1297 entity = ((class_3966)hitResult).method_17782();
            if (projectile != null && entity instanceof class_1309 && (entityBlocking = (class_1309)entity).method_6061(new class_1282("parry_this"){

                public class_243 method_5510() {
                    return projectile.method_19538();
                }
            }) && entityBlocking.method_6030().method_7909().method_7881(entityBlocking.method_6030()) - entityBlocking.method_6014() <= (Integer)TFConfig.COMMON_CONFIG.SHIELD_INTERACTIONS.shieldParryTicksThrowable.get()) {
                class_243 playerVec3 = entityBlocking.method_5720();
                projectile.method_7485(playerVec3.field_1352, playerVec3.field_1351, playerVec3.field_1350, 1.1f, 0.1f);
                projectile.method_7432((class_1297)entityBlocking);
                return true;
            }
        }
        return false;
    }

    static {
        allowDismount = false;
        globalParry = !FabricLoader.getInstance().isModLoaded("parry");
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<ManipulateDrops> {
        public ManipulateDrops read(class_2960 name, JsonObject json, class_5341[] conditionsIn) {
            return new ManipulateDrops(conditionsIn);
        }

        public JsonObject write(ManipulateDrops instance) {
            return null;
        }
    }

    public static class ManipulateDrops
    extends LootModifier {
        protected ManipulateDrops(class_5341[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        protected List<class_1799> doApply(List<class_1799> generatedLoot, class_47 context) {
            ArrayList<class_1799> newLoot = new ArrayList<class_1799>();
            boolean flag = false;
            if (shouldMakeGiantCobble && generatedLoot.size() > 0 && generatedLoot.get(0).method_7909() == class_1792.method_7867((class_2248)class_2246.field_10445)) {
                generatedLoot.remove(0);
                if (amountOfCobbleToReplace == 64) {
                    newLoot.add(new class_1799((class_1935)TFBlocks.GIANT_COBBLESTONE.get()));
                    flag = true;
                }
                if (--amountOfCobbleToReplace <= 0) {
                    shouldMakeGiantCobble = false;
                }
            }
            return flag ? newLoot : generatedLoot;
        }
    }
}

